#ifndef JEU_H_INCLUDED
#define JEU_H_INCLUDED

#include <stdio.h>
#include <SDL/SDL_image.h>
#include "affichage.h"
#include "reseau.h"

#define RESSOURCES_DIR "ressources/"
#define MAPS_DIR "maps/"
#define SAVES_DIR "saves/"

#define TILE_TAILLE 32

typedef enum enum_tile_type //Comportement d'une case de la map
{
    SOL,        // Type Sol -> Franchissable
    OBSTACLE,   // Type Obstacle -> Ne peut pas tre travers
    CAMP,       // Type Camp -> Ne peut pas tre travers (seul un drapeau peut s'y trouver)
    MORTEL      // Type Mortel -> Tue le personnage qui s'y trouve
}tile_type;

typedef enum enum_type_pion //Rang d'un pion
{
    GRAAL = 0, //Drapeau du sujet
    ECLAIREUR = 1,
    PECORE = 2, //Pitaille/Chair  canon du sujet
    CHEVALIER = 3 //Troupe de choc du sujet
}type_pion;

typedef struct s_pion //Dcrit un pion
{
    long joueur; //Joueur qui possde le pion
    type_pion type; //Son type
    long pos_x, pos_y; //Sa position sur la map
    char pts, pts_max; //Ses points de dplacement restants et maximum
    long graal; //Vaut le numro du joueur dont l'unit porte le graal (0 sinon)
    long deplace; //Vaut le numro de dplacement (si c'est le 3me pion  bouger : deplace = 3) ou 0 s'il n'a pas encore boug
}t_pion;

typedef struct s_tile //Dcrit un type de case
{
    tile_type type; //Son comportement
    char cout_pts; //Son cot de dplacement
}t_tile;

typedef struct s_tileset { // Structure d'un Tileset
    char *fichier;      // Donnes du fichier du tileset  envoyer aux clients
    long taille;        // Taille du fichier
    long largeur;       // Nombre de tile en largeur
    long hauteur;       // Nombre de tile en hauteur
} t_tileset;

typedef struct s_map { // Structure de la Map
    char *fichier;      // Donnes du fichier de la map  envoyer aux clients
    long taille;        // Taille du fichier
    long largeur;       // Largeur de la map
    long hauteur;       // Hauteur de la map
    long **cases;       // Tableau 2D des cases de la map

    t_tileset tileset;  // Tileset du dcor de la map
    t_tile *tiles;      // Liste des tiles de la map
} t_map;

typedef struct s_partie //Dcrit une partie complte
{
    long jeu; //Vaut Vrai si la partie est en cours
    long tour; //Joueur dont c'est le tour
    long deplacement; //Nombre de dplacement lors de ce tour
    long dist_inc, dist_vis; //Distance de dcouverte du terrain et de visibilit

    char nbr_pions_depart[4]; //Nombre de pions de dpart par catgorie
    long nbr_pions; //Nombre de pions par joueurs
    t_pion *pions; //Contient tous les pions de la partie

    t_map map; //Reprsentation de la map
    long map_chargee; //Vaut Vrai si on a charg une map
}t_partie;

long jeu_init(t_partie *jeu); //Initialise les variables de la structure partie
void jeu_quit(t_reseau *res, t_partie *jeu); //Libre la mmoire utilise pour une partie
void traiter_paquets(t_affichage *aff, t_reseau *res, t_partie *jeu); //Traite les paquets reus
long initialiser_pions(t_reseau *res, t_partie *jeu); //Initialise les pions au dbut de la partie
void recharger_pts(t_pion *pions, long nbr_pions, long num); //Recharge les points de mouvement des units du joueur num
long charger_map(t_reseau *res, t_map *map, char *fichier_nom, char *fichier_tile); //Charge un fichier .map
void supprimer_map(t_reseau *res, t_map *map); //Libre la mmoire alloue pour une map
void test_campeur(t_reseau *res, t_partie *jeu, long num); //Test si le joueur num campe  sa position de dpart
long sauvegarder(t_affichage *aff, t_reseau *res, t_partie *jeu, char *nom); //Sauvegarde la partie en cours
long charger(t_affichage *aff, t_reseau *res, t_partie *jeu, char *nom); //Charge une partie

#endif // JEU_H_INCLUDED
